/* 
 *  JoinRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.InteractionI;

public class JoinRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(JoinRequest.class);
    private final String destinationInteractionID;

    public JoinRequest(String sourceInteractionID, String destinationInteractionID) {
        super(LOG, sourceInteractionID);
        this.destinationInteractionID = destinationInteractionID;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        InteractionI interactionSource = getInteraction();
        InteractionI interactionDestination = getSession().findInteraction(destinationInteractionID);
        if (interactionDestination == null) {
            LOG.error(methodName + " failed to find destination interaction with id:" + destinationInteractionID);
            return null;
        }
        interactionSource.joinConference(interactionDestination);
        LOG.trace(methodName + "-");
        return null;
    }
}
